//------------------------------------------------------------------------------
// File: PicketStart.cs
// This file is responsible for implementing the initial state for protesting,
// which starts the character picketing
// Author: Matthew Rudge
//------------------------------------------------------------------------------

////////////////////////////////////////////////////////////////////////////////
//! Called when the start picket state is entered
//! \param %cmpAI AI component
////////////////////////////////////////////////////////////////////////////////
function AISMN_PicketStart::OnEnter(%this, %cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Called when the start picket state is exited
//! \param %cmpAI AI component
////////////////////////////////////////////////////////////////////////////////
function AISMN_PicketStart::OnExit(%this, %cmpAI)
{
   return;
}

////////////////////////////////////////////////////////////////////////////////
//! Called every update for the start picket state
//! \param %cmpAI AI component
////////////////////////////////////////////////////////////////////////////////
function AISMN_PicketStart::Update(%this, %cmpAI)
{
    // Get object
   %obj = GetThisObject(%cmpAI);
   
   // Quit whatever job the character has
   slgUnemployObject(%obj);
   
   // Restore character's outfit (mounts protest sign)
   RestoreCharacterOutfit(%cmpAI);
   
   // Immediate exit of state
   ReturnValue(%cmpAI, 0);
   return;
}

// End PicketStart.cs